<?xml version="1.0" encoding="UTF-8"?>
<!-- 
    Schematron schema for validation of authentication tokens.
    This schema is intended as a development aid for building AORTA-compliant authentication tokens.
    It is not intended as a fully functional production-quality security check.
    
    For now the queryBinding SHALL be xslt (Schematron default), because the XSG from CSC
    does not support XSLT 2.0
    This meant removal of the include xml.sch, because that heavily relies on xslt2

    Copyright 2008-2010, Nictiz
-->
<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt">
    <title>Schematronvalidatie van AuthenticationToken</title>
    <ns uri="urn:hl7-org:v3" prefix="hl7"/>
    <ns uri="http://www.w3.org/2001/XMLSchema" prefix="xs"/>
    <ns uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi"/>
    <ns uri="http://www.aortarelease.nl/805/" prefix="ao"/>
    <ns uri="http://schemas.xmlsoap.org/soap/envelope/" prefix="soap"/>
    <!--include href="coreschematron/xml.sch"/-->
    <pattern>
        <title>AuthenticationToken</title>
        <rule context="/soap:Envelope[1]/soap:Header/*">
            <assert role="error" test="@soap:actor='http://www.aortarelease.nl/actor/gbx' or @soap:actor='http://www.aortarelease.nl/actor/zim'"
                ><value-of select="name()"/>/@soap:actor='<value-of select="@soap:actor"/>' MOET een zijn van 'http://www.aortarelease.nl/actor/gbx', 'http://www.aortarelease.nl/actor/zim'</assert>
        </rule>
        <rule context="/soap:Envelope[1]/soap:Header[1]/ao:authenticationTokens[1]/ao:signedData[1]">
            <!-- Transmission wrapper elements are located by looking for interactionId siblings... -->
            <assert role="error"
                test="ao:authenticationData/ao:messageId/ao:root =//hl7:interactionId/../hl7:id/@root"
                >Root in messageId moet gelijk zijn aan message.id root</assert>
            <assert role="error"
                test="ao:authenticationData/ao:messageId/ao:extension = //hl7:interactionId/../hl7:id/@extension"
                >Extension in messageId moet gelijk zijn aan message.id root</assert>
            <assert role="error"
                test="ao:authenticationData/ao:notBefore &lt; ao:authenticationData/ao:notAfter "
                >Datum notBefore moet voor notAfter liggen</assert>
            <assert role="error"
                test="ao:authenticationData/ao:addressedParty/ao:root = '2.16.840.1.113883.2.4.6.6'"
                >Root in addressedParty moet '2.16.840.1.113883.2.4.6.6' zijn</assert>
            <assert role="error"
                test="ao:authenticationData/ao:addressedParty/ao:extension = '1'"
                >Extension in addressedParty moet '1' zijn</assert>
            
            <let name="codeValue" value="ao:coSignedData/ao:triggerEventId"/>
            <let name="interactionId" value="//hl7:interactionId[1]/@extension"/>
            <!-- 
                Sinds Oxygen 11.0 met Saxon EE kun je blijkbaar geen variabelen meer aanroepen binnen een let
                Bij gebruik van onderstaande $vocabFile blijkt de concat een sequence op te leveren in plaats 
                van een string (singleton). Als je echter de inhoud van de variabele in de asserts gebruikt, 
                dan gaat alles goed. Gemeld bij Oxygen support 
            -->
            <let name="vocabFile" value="concat('../vocab/',//hl7:interactionId[1]/@root,'.xml')"/>
            <assert role="error" test="document(concat('../vocab/',//hl7:interactionId[1]/@root,'.xml'))/*/hl7:code[@code=$interactionId]/hl7:reference[@extension=$codeValue]"
                >coSignedData/triggerEventId '<value-of select="$codeValue"/>' (Trigger Event) moet 
                '<value-of select="document(concat('../vocab/',//hl7:interactionId[1]/@root,'.xml'))/*/hl7:code[@code=$interactionId]/hl7:reference/@extension"/>' zijn </assert>
            <!-- In HL7 staat BSN in element met root '2.16.840.1.113883.2.4.6.3' -->
            <!-- Letterlijk: niet een BSN in payload is ongelijk aan BSN in token (== alle BSN's in payload zijn gelijk aan die in token)  -->
            <assert role="error"
                test="not(ao:coSignedData/ao:patientId/ao:extension != //node()[@root='2.16.840.1.113883.2.4.6.3']/@extension) "
                >BSN in token moet overeenkomen met BSN in payload</assert>
            <assert role="error"
                test="((ao:coSignedData/ao:patientId/ao:root = '2.16.840.1.113883.2.4.6.3')  or not(//node()[@root='2.16.840.1.113883.2.4.6.3']/@extension))"
                >Token moet het burgerservicenummer bevatten</assert>
        </rule>
    </pattern>
</schema>
